﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Car_Demo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // Metoda GetCarData() akceptuje argument w postaci
        // obiektu Car. Dane wprowadzone przez użytkownika
        // zostają przypisane właściwościom obiektu.
        private void GetCarData(Car car)
        {
            // Zmienne tymczasowe przechowujące
            // przebieg, cenę i liczbę drzwi samochodu.
            int mileage;
            decimal price;
            int doors;

            // Pobranie producenta samochodu.
            car.Make = makeTextBox.Text;

            // Pobranie modelu samochodu.
            car.Model = modelTextBox.Text;

            // Pobranie przebiegu samochodu.
            if (int.TryParse(mileageTextBox.Text, out mileage))
            {
                car.Mileage = mileage;

                // Pobranie ceny samochodu.
                if (decimal.TryParse(priceTextBox.Text, out price))
                {
                    car.Price = price;

                    // Pobranie liczby drzwi w samochodzie.
                    if (int.TryParse(doorsTextBox.Text, out doors))
                    {
                        car.Doors = doors;
                    }
                    else
                    {
                        // Wyświetlenie komunikatu błędu.
                        MessageBox.Show("Niepoprawna liczba drzwi.");
                    }
                }
                else
                {
                    // Wyświetlenie komunikatu błędu.
                    MessageBox.Show("Niepoprawna cena.");
                }
            }
            else
            {
                // Wyświetlenie komunikatu błędu.
                MessageBox.Show("Niepoprawny przebieg.");
            }
        }

        private void createObjectButton_Click(object sender, EventArgs e)
        {
            // Utworzenie obiektu klasy Car.
            Car myCar = new Car();

            // Pobranie danych samochodu.
            GetCarData(myCar);

            // Wyświetlenie danych samochodu.
            makeLabel.Text = myCar.Make;
            modelLabel.Text = myCar.Model;
            mileageLabel.Text = myCar.Mileage.ToString();
            priceLabel.Text = myCar.Price.ToString("c");
            doorsLabel.Text = myCar.Doors.ToString();
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
